/**
 * 日期选项配置
 * @param {*} type 0：从今天开始往前，-1 则是 T - 1 开始日期往前
 * @returns {}
 */
export const useDatePickerOptions = (type = -1) => {
  const last30Date = [new Date().setDate((new Date().getDate() - (30 - 1))), new Date().setDate((new Date().getDate() + type))]
  const last7Date = [new Date().setDate((new Date().getDate() - (7 - 1))), new Date().setDate((new Date().getDate() + type))]
  const lastDate = [new Date().setDate((new Date().getDate() + type)), new Date().setDate((new Date().getDate() + type))]
  // 今日 0 点到 24 点
  const today = new Date();
  today.setHours(0, 0, 0, 0);
  const tomorrow = new Date();
  tomorrow.setDate(tomorrow.getDate());
  tomorrow.setHours(23, 59, 59, 59);
  const todayDate = [today, tomorrow]
  // 今年的 1.1 号到 12.31号
  const thisYearDate = [new Date(new Date().getFullYear(), 0, 1), new Date(new Date().getFullYear(), 11, 31)]
  const recentPickerOptions = ref([// 日期选项配置
    {
      text: '今天',
      value() {
        return todayDate
      }
    },
    {
      text: '最近一周',
      value() {
        const end = new Date().setDate((new Date().getDate() + type));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * (7 - 1));
        return [start, end]
      }
    }, {
      text: '最近一个月',
      value() {
        const end = new Date().setDate((new Date().getDate() + type));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * (30 - 1));
        return [start, end]
      }
    }
  ])
  // 上个月/上一周的 pickerOptions
  const lastPickerOptions = ref([
    {
      text: '上一月',
      value() {
        const end = new Date();
        end.setDate(0); // 设置为上个月的最后一天
        const start = new Date(end.getFullYear(), end.getMonth(), 1); // 设置为上个月的第一天
        return [start, end];
      }
    },
    {
      text: '上一周',
      value() {
        const end = new Date();
        end.setDate(end.getDate() - end.getDay()); // 设置为上一周的周日
        const start = new Date(end.getFullYear(), end.getMonth(), end.getDate() - 6); // 设置为上一周的周一
        return [start, end];
      }
    }
  ])
  return {
    todayDate, // 今天
    lastDate, // 昨天
    last30Date, // 前 30 天
    last7Date, // 前 7 天
    thisYearDate, // 今年 1.1 号到 12.31 号
    recentPickerOptions, // 最近一周/一月
    lastPickerOptions // 上一周/上一月
  }
}