import { getVersionAPI } from '@/api'
import cache from '@/plugins/cache'

export default defineStore(
  'version',
  {
    state: () => ({
      version: cache.local.get('version') || '',
      versionChange: false, // 版本号是否发生变化
      versionList: [] // 版本说明信息列表（最新版）
    }),
    actions: {
      // 获取版本信息
      getVersion() {
        return new Promise((resolve, reject) => {
          getVersionAPI().then(res => {
            this.versionChange = !(this.version === res.data[0]?.version)
            this.version = res.data[0]?.version
            // 组织版本内容数据
            this.versionList = res.data[0]?.changes.map(o => {
              return {
                title: o.type,
                content: o.desc
              }
            })
            resolve(res)
          }).catch(error => {
            reject(error)
          })
        })
      }
    }
  })

