package com.sfa.system.pojo.response;

import com.sfa.common.core.annotation.Excel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-10-30 18
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SysPostDto {

    /** 岗位序号 */
    @Excel(name = "岗位序号", cellType = Excel.ColumnType.NUMERIC)
    private Long postId;

    /** 岗位编码 */
    @Excel(name = "岗位编码")
    private String postCode;

    /** 岗位名称 */
    @Excel(name = "岗位名称")
    private String postName;

    /** 岗位排序 */
    @Excel(name = "岗位排序")
    private Integer postSort;

    /** 考勤规则ID */
    private Long ruleId;

    /** 考勤规则名称 */
    private String ruleName;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /** 用户是否存在此岗位标识 默认不存在 */
    private boolean flag = false;

    /** 创建者 */
    private String createBy;

    /** 创建者 */
    private Long createUserId;

    /** 创建时间 */
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新者 */
    private Long updateUserId;

    /** 更新时间 */
    private Date updateTime;

    /** 备注 */
    private String remark;
}
