package com.sfa.system.pojo.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalTime;
import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdmKqRuleVo {

    /** 规则ID */
    private Long ruleId;

    /** 规则编号 */
    @Excel(name = "规则编号")
    @Size(min = 6,max = 6,message = "规则编号为6位字符")
    private String ruleNum;

    /** 规则名称 */
    @Excel(name = "规则名称")
    @NotNull(message = "规则名称不可为空")
    private String ruleName;

    /** 上班打卡允许开始时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    @NotNull(message = "上班时间范围不可为空")
    private LocalTime firBegintime;

    /** 上班打卡允许结束时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    @NotNull(message = "上班时间范围不可为空")
    private LocalTime firEndtime;

    /** 午班打卡允许开始时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    private LocalTime secBegintime;

    /** 午班打卡允许结束时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    private LocalTime secEndtime;

    /** 下班打卡允许开始时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    @NotNull(message = "下班时间范围不可为空")
    private LocalTime thiBegintime;

    /** 下班打卡允许结束时间 */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "HH:mm:ss")
    @NotNull(message = "下班时间范围不可为空")
    private LocalTime thiEndtime;


    /** 创建/修改者 */
    private String createBy;
    private Long createUserId;
    private String updateBy;
    private Long updateUserId;

    /** 备注 */
    private String remark;

    /** 记录版本 */
    private Long flag;
}
