package com.sfa.system.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;

/**
 * 用户关联促销用户表
 * @TableName sys_user_pro
 */
@TableName(value ="sys_user_pro")
@Data
public class SysUserPro extends BaseDo {
    /**
     * 用户登录账号/工号
     */
    private String userName;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 权限(1:oneself,2:admin)
     */
    private Integer privilegeId;

    /**
     * 帐号状态（0正常 1停用）
     */
    private String status;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}