package com.sfa.system.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.system.api.domain.SysOperLog;
import com.sfa.system.domain.dao.ISysOperLogDao;
import com.sfa.system.domain.mapper.SysOperLogMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 操作日志 服务层处理
 * 
 * @author ruoyi
 */
@Service
public class SysOperLogDaoImpl implements ISysOperLogDao
{
    @Autowired
    private SysOperLogMapper operLogMapper;

    /**
     * 新增操作日志
     * 
     * @param operLog 操作日志对象
     * @return 结果
     */
    @Override
    public int insertOperlog(SysOperLog operLog)
    {
        return operLogMapper.insertOperlog(operLog);
    }

    /**
     * 查询系统操作日志集合
     * 
     * @param operLog 操作日志对象
     * @return 操作日志集合
     */
    @Override
    public PageInfo selectOperLogList(SysOperLog operLog)
    {
        LambdaQueryWrapper<SysOperLog> qw = buildWrapper(operLog);
        Page<SysOperLog> pageR = operLogMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo<SysOperLog> pageInfo = new PageInfo<>(pageR);
        return pageInfo;
    }

    private LambdaQueryWrapper<SysOperLog> buildWrapper(SysOperLog operLog) {
        LambdaQueryWrapper<SysOperLog> qw =new LambdaQueryWrapper<>();
        if (Objects.nonNull(operLog.getBusinessType())){
            qw.eq(SysOperLog::getBusinessType,operLog.getBusinessType());
        }
        if (Objects.nonNull(operLog.getStatus())){
            qw.eq(SysOperLog::getStatus,operLog.getStatus());
        }
        if (Objects.nonNull(operLog.getBusinessTypes())){
            qw.in(SysOperLog::getBusinessType,operLog.getBusinessTypes());
        }
        if (StringUtils.isNotBlank(operLog.getOperIp())){
            qw.like(SysOperLog::getOperIp,operLog.getOperIp());
        }
        if (StringUtils.isNotBlank(operLog.getTitle())){
            qw.like(SysOperLog::getTitle,operLog.getTitle());
        }
        if (StringUtils.isNotBlank(operLog.getOperName())){
            qw.like(SysOperLog::getOperName,operLog.getOperName());
        }
        if (Objects.nonNull(operLog.getBeginTime())&&Objects.nonNull(operLog.getEndTime())){
            qw.between(SysOperLog::getOperTime, operLog.getBeginTime(),operLog.getEndTime());
        }
        qw.orderByDesc(SysOperLog::getOperId);
        return qw;
    }

    /**
     * 批量删除系统操作日志
     * 
     * @param operIds 需要删除的操作日志ID
     * @return 结果
     */
    @Override
    public int deleteOperLogByIds(Long[] operIds)
    {
        return operLogMapper.deleteOperLogByIds(operIds);
    }

    /**
     * 查询操作日志详细
     * 
     * @param operId 操作ID
     * @return 操作日志对象
     */
    @Override
    public SysOperLog selectOperLogById(Long operId)
    {
        return operLogMapper.selectOperLogById(operId);
    }

    /**
     * 清空操作日志
     */
    @Override
    public void cleanOperLog()
    {
        operLogMapper.cleanOperLog();
    }
}
