package com.sfa.system.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.system.api.domain.SysLogininfor;
import com.sfa.system.domain.dao.ISysLogininforDao;
import com.sfa.system.domain.mapper.SysLogininforMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 系统访问日志情况信息 服务层处理
 * 
 * @author ruoyi
 */
@Service
public class SysLogininforDaoImpl implements ISysLogininforDao
{

    @Autowired
    private SysLogininforMapper logininforMapper;

    /**
     * 新增系统登录日志
     * 
     * @param logininfor 访问日志对象
     */
    @Override
    public int insertLogininfor(SysLogininfor logininfor)
    {
        return logininforMapper.insertLogininfor(logininfor);
    }

    /**
     * 查询系统登录日志集合
     * 
     * @param logininfor 访问日志对象
     * @return 登录记录集合
     */
    @Override
    public PageInfo selectLogininforList(SysLogininfor logininfor)
    {
        LambdaQueryWrapper<SysLogininfor> qw = buildWrapper(logininfor);
        Page<SysLogininfor> pageR = logininforMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo<SysLogininfor> pageInfo = new PageInfo<>(pageR);
        return pageInfo;
    }

    private LambdaQueryWrapper<SysLogininfor> buildWrapper(SysLogininfor logininfor) {
        LambdaQueryWrapper<SysLogininfor> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(logininfor.getStatus())){
            qw.eq(SysLogininfor::getStatus,logininfor.getStatus());
        }
        if (StringUtils.isNotBlank(logininfor.getIpaddr())){
            qw.eq(SysLogininfor::getIpaddr,logininfor.getIpaddr());
        }
        if (StringUtils.isNotBlank(logininfor.getUserName())){
            qw.eq(SysLogininfor::getUserName,logininfor.getUserName());
        }
        if (Objects.nonNull(logininfor.getBeginTime())&&Objects.nonNull(logininfor.getEndTime())){
            qw.between(SysLogininfor::getAccessTime, logininfor.getBeginTime(),logininfor.getEndTime());
        }
        qw.orderByDesc(SysLogininfor::getInfoId);
        return qw;
    }

    /**
     * 批量删除系统登录日志
     * 
     * @param infoIds 需要删除的登录日志ID
     * @return 结果
     */
    @Override
    public int deleteLogininforByIds(Long[] infoIds)
    {
        return logininforMapper.deleteLogininforByIds(infoIds);
    }

    /**
     * 清空系统登录日志
     */
    @Override
    public void cleanLogininfor()
    {
        logininforMapper.cleanLogininfor();
    }
}
