package com.sfa.system.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-09-05 11
 * @describe :
 */
@Component
public class TencentLbsUtil {

    @Value("${tencent.lbs.key}")
    private String key;
    @Value("${tencent.lbs.url}")
    private String url;

    public JSONObject addressByLocation(String location){
        Map<String,Object> params = new HashMap<>();
        params.put("location",location);
        params.put("key",key);
        String bodyStr = HttpUtil.get(url, params);
        return JSONObject.parseObject(bodyStr);
    }
}
