package com.sfa.system.domain.dao.impl;

import com.sfa.system.domain.dao.ISysUserProDao;
import com.sfa.system.domain.entity.SysUserPro;
import com.sfa.system.domain.mapper.SysUserProMapper;
import com.sfa.system.pojo.response.SysUserProDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-01-15 14
 * @describe :
 */
@Service
public class SysUserProDaoImpl implements ISysUserProDao {

    @Autowired
    private SysUserProMapper sysUserProMapper;
    @Override
    public void insertOrUpdate(String userName, String nickName, Integer privilegeId, String proStatus) {
        SysUserPro sDo = new SysUserPro();
        sDo.setUserName(userName);
        sDo.setNickName(nickName);
        sDo.setPrivilegeId(privilegeId);
        sDo.setStatus(proStatus);
        sysUserProMapper.insertOrUpdate(sDo);
    }

    @Override
    public SysUserProDto selectOne(String userName) {
        return sysUserProMapper.selectOneByUserName(userName);
    }
}
