package com.sfa.system.service.query.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.system.domain.entity.SysQuery;
import com.sfa.system.domain.mapper.SysQueryMapper;
import com.sfa.system.pojo.request.GeneralQueryVo;
import com.sfa.system.pojo.response.GeneralQueryResponse;
import com.sfa.system.service.query.IGeneralQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-24 15
 * @describe :
 */
@Service
public class IGeneralQueryServiceImpl implements IGeneralQueryService {

    @Autowired
    SysQueryMapper sysQueryMapper;

    @Override
    public GeneralQueryResponse queryTableDatas(GeneralQueryVo generalQueryVo) {
        GeneralQueryResponse generalQueryResponse = new GeneralQueryResponse();

        SysQuery sysQuery = sysQueryMapper.selectById(generalQueryVo.getQueryId());
//        主查询语句、默认查询条件、动态查询条件
        String querySql = sysQuery.getQuerySql();
        String queryWhere = sysQuery.getQueryWhere();
        Map boxheadSelectMap = JSONObject.parseObject(sysQuery.getBoxheadSelect(), Map.class);
        StringBuilder sqlBu = new StringBuilder(querySql).append(queryWhere);

//       动态查询条件、前端参数进行动态拼接 -->>where cooperate_status = '1' and  dealer_name like '%苏州%' and dealer_mgr like '%何亚%';
        Map<String, String> wheres = generalQueryVo.getWheres();
        if (Objects.nonNull(boxheadSelectMap) && Objects.nonNull(wheres)){
            for (Map.Entry<String, String> entry : wheres.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String selectType = boxheadSelectMap.get(key).toString();
                if (selectType.equals("like")){
                    sqlBu.append(" and ").append(key).append(" like '%").append(value).append("%' ");
                }
            }
        }


        List<HashMap<String,Object>> objs= sysQueryMapper.queryTableDatas(sqlBu.toString());
        List<Map> boxhead = JSONArray.parseArray(sysQuery.getBoxhead(),Map.class);
        generalQueryResponse.setBoxhead(boxhead)
                .setQueryNum(sysQuery.getQueryNum())
                .setQueryDisplay(JSONArray.parseArray(sysQuery.getQueryDisplay(), Map.class))
                .setRows(objs);
        return generalQueryResponse;
    }



}
