package com.sfa.system.service.core.impl;

import com.sfa.system.api.pojo.request.UserVo;
import com.sfa.system.domain.dao.ISysPostDao;
import com.sfa.system.domain.dao.ISysUserDao;
import com.sfa.system.pojo.response.SysPostDto;
import com.sfa.system.service.core.ISysUserCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-30 17
 * @describe :
 */
@Service
public class SysUserCoreServiceImpl implements ISysUserCoreService {

    @Autowired
    ISysUserDao sysUserDao;
    @Autowired
    ISysPostDao sysPostService;

    @Override
    public void insertUser(UserVo userVo) {
        SysPostDto sysPostDto = sysPostService.selectPostByPostCode(userVo.getPostCode());
//        关联岗位、考勤规则
        if (Objects.nonNull(sysPostDto)){
            userVo.setPostCode(sysPostDto.getPostCode())
                    .setPostName(sysPostDto.getPostName())
                    .setRuleNum(sysPostDto.getRuleNum())
                    .setRuleName(sysPostDto.getRuleName());
        }
        sysUserDao.insertUser(userVo);
    }
}
