package com.sfa.system.controller.core;

import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.system.api.pojo.request.UserVo;
import com.sfa.system.service.ISysDeptService;
import com.sfa.system.service.ISysRoleService;
import com.sfa.system.service.core.ISysUserCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-10-30 17
 * @describe :
 */
@RestController
@RequestMapping("/user")
public class SysUserCoreController {

    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private ISysUserCoreService sysUserService;
    /**
     * 新增用户
     */
    @RequiresPermissions("system:user:add")
    @Log(title = "用户管理", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@Validated @RequestBody UserVo userVo)
    {
        deptService.checkDeptDataScope(userVo.getDeptId());
        roleService.checkRoleDataScope(userVo.getRoleIds());
        userVo.setCreateUserId(SecurityUtils.getUserId());
        userVo.setCreateBy(SecurityUtils.getUsername());
        userVo.setPassword(SecurityUtils.encryptPassword(userVo.getPassword()));
        sysUserService.insertUser(userVo);
    }
}
