package com.sfa.system.controller.core;

import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.system.api.pojo.request.UserVo;
import com.sfa.system.domain.dao.ISysDeptDao;
import com.sfa.system.domain.dao.ISysRoleDao;
import com.sfa.system.service.core.ISysUserCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-30 17
 * @describe :
 */
@RestController
@RequestMapping("/user")
public class SysUserCoreController {

    @Autowired
    private ISysRoleDao roleDao;
    @Autowired
    private ISysDeptDao deptDao;
    @Autowired
    private ISysUserCoreService sysUserService;

    /**
     * 新增用户
     */
    @RequiresPermissions("system:user:add")
    @Log(title = "用户管理", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@Validated @RequestBody UserVo userVo) {
        deptDao.checkDeptDataScope(userVo.getDeptId());
        roleDao.checkRoleDataScope(userVo.getRuleId());
        userVo.setCreateUserId(SecurityUtils.getUserId());
        userVo.setCreateBy(SecurityUtils.getUsername());
        userVo.setPassword(SecurityUtils.encryptPassword(userVo.getPassword()));
        sysUserService.insertUser(userVo);
    }


    /**
     * 修改用户
     */
    @RequiresPermissions("system:user:edit")
    @Log(title = "用户管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public void edit(@Validated @RequestBody UserVo userVo) {
        deptDao.checkDeptDataScope(userVo.getDeptId());
        roleDao.checkRoleDataScope(userVo.getRoleIds());
        userVo.setUpdateUserId(SecurityUtils.getUserId());
        userVo.setUpdateBy(SecurityUtils.getUsername());
        sysUserService.updateUser(userVo);

        if (Objects.isNull(userVo.getPrivilegeId())){
            return;
        }
        // 开通促销账号
        sysUserService.openPromotion(userVo);
    }
}
