package com.sfa.system.controller.aliyun;

import com.alibaba.fastjson.JSONObject;
import com.sfa.system.utils.AliyunUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-02-06 13
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/aliyun/")
public class AliyunGetToken {

    @Autowired
    private AliyunUtil aliyunUtil;

    @GetMapping("/sts_token")
    public Object getStsToken() {
        try {
            JSONObject stsToken = aliyunUtil.getStsToken();
            return stsToken;
        } catch (Exception e) {
            return e.getMessage();
        }
    }
}
