package com.sfa.system.utils;


import com.alibaba.fastjson.JSONObject;
import com.aliyun.sts20150401.Client;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * @author : liqiulin
 * @date : 2025-02-06 13
 * @describe :
 */
@Component
public class AliyunUtil {

    @Value("${aliyun.access-key-id}")
    private String OSS_ACCESS_KEY_ID;
    @Value("${aliyun.access-key-secret}")
    private String OSS_ACCESS_KEY_SECRET;
    @Value("${aliyun.halogen-oss.region-id}")
    private String REGION_ID;
    @Value("${aliyun.halogen-oss.bucket-name}")
    private String BUCKET_NAME;
    @Value("${aliyun.halogen-oss.web-js-link}")
    private String WEB_JS_LIN;
    @Value("${aliyun.halogen-oss.sts-role-arm}")
    private String OSS_STS_ROLE_ARN;
    public JSONObject getStsToken() throws Exception {
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config()
                .setAccessKeyId(OSS_ACCESS_KEY_ID)
                .setAccessKeySecret(OSS_ACCESS_KEY_SECRET);
        config.endpoint = "sts." + REGION_ID + ".aliyuncs.com";
        Client client = new Client(config);

        com.aliyun.sts20150401.models.AssumeRoleRequest assumeRoleRequest = new com.aliyun.sts20150401.models.AssumeRoleRequest()
                .setDurationSeconds(3600L)
                .setRoleArn(OSS_STS_ROLE_ARN)
                .setRoleSessionName("000516");
        com.aliyun.teautil.models.RuntimeOptions runtime = new com.aliyun.teautil.models.RuntimeOptions();
        com.aliyun.sts20150401.models.AssumeRoleResponse assumeRoleResponse = client.assumeRoleWithOptions(assumeRoleRequest, runtime);

        JSONObject rj = JSONObject.parseObject(JSONObject.toJSONString(assumeRoleResponse.body.getCredentials()));
        rj.put("web_js_link",BUCKET_NAME);
        rj.put("region",REGION_ID);
        return rj;
    }

}