package com.sfa.system.controller.query;

import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.api.pojo.response.MdmKqRuleDto;
import com.sfa.system.service.core.IMdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.sfa.common.security.annotation.RequiresPermissions;

import java.time.LocalTime;

/**
 * @author : liqiulin
 * @date : 2024-11-04 11
 * @describe :
 */
@RestController
@RequestMapping("/kq_rule")
public class KqRuleQueryController extends BaseController {
    @Autowired
    private IMdmKqRuleService mdmKqRuleService;

    /**
     * 查询考勤规则列表
     */
    @RequiresPermissions("system:kq_rule:list")
    @GetMapping("/list")
    public PageInfo list(MdmKqRuleVo mdmKqRuleVo) {
        return mdmKqRuleService.selectMdmKqRuleList(mdmKqRuleVo);
    }

//    /**
//     * 导出考勤规则列表
//     */
//    @RequiresPermissions("system:kq_rule:list")
//    @Log(title = "考勤规则", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, MdmKqRuleVo mdmKqRuleVo)
//    {
//        List<MdmKqRuleVo> list = mdmKqRuleService.selectMdmKqRuleList(mdmKqRule);
//        ExcelUtil<MdmKqRule> util = new ExcelUtil<MdmKqRule>(MdmKqRule.class);
//        util.exportExcel(response, list, "考勤规则数据");
//    }

    /**
     * 获取考勤规则详细信息
     */
    @RequiresPermissions("system:kq_rule:list")
    @GetMapping(value = "/{ruleId}")
    public MdmKqRuleDto getInfo(@PathVariable("ruleId") Long ruleId) {
        MdmKqRuleDto mdmKqRuleDto = mdmKqRuleService.selectMdmKqRuleByRuleId(ruleId);
        mdmKqRuleDto.setCurrently(LocalTime.now());
        return mdmKqRuleDto;
    }
}
