package com.sfa.system.service.query.impl;

import com.sfa.system.api.pojo.response.SiteDto;
import com.sfa.system.domain.dao.IMdmCityDao;
import com.sfa.system.service.query.ISiteQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-31 16
 * @describe :
 */
@Service
public class SiteQueryServiceImpl implements ISiteQueryService {

    @Autowired
    IMdmCityDao iMdmCityDao;

    /**
     * 查询行政区域
     * @param provinceNum 查询市下的区
     * @param cityNum 查询
     * @return
     */
    @Override
    public List<SiteDto> regionList(String provinceNum,String cityNum) {
        return iMdmCityDao.regionList(provinceNum, cityNum);
    }

    @Override
    public SiteDto getCountyName(String provinceName,String cityName,String countyName) {
        return iMdmCityDao.getCountyName(provinceName,cityName,countyName);
    }

}
