package com.sfa.system.domain.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.system.domain.entity.SysQuery;
import com.sfa.system.domain.mapper.SysQueryMapper;
import com.sfa.system.pojo.request.GeneralQueryVo;
import com.sfa.system.pojo.response.GeneralQueryResponse;
import com.sfa.system.domain.dao.IGeneralDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-24 15
 * @describe :
 */
@Service
public class GeneralDaoImpl implements IGeneralDao {

    @Autowired
    SysQueryMapper sysQueryMapper;

    @Override
    public GeneralQueryResponse queryTableDatas(GeneralQueryVo generalQueryVo) {
        GeneralQueryResponse generalQueryResponse;
        SysQuery sysQuery = sysQueryMapper.selectById(generalQueryVo.getQueryId());

        //        主查询语句、默认查询条件、动态查询条件
        String querySql = sysQuery.getQuerySql();
        String queryWhere = sysQuery.getQueryWhere();
        Map boxheadSelectMap = JSONObject.parseObject(sysQuery.getBoxheadSelect(), Map.class);
        StringBuilder sqlBu = new StringBuilder(querySql).append(queryWhere);

        StringBuilder sqlCountBu = null;
        if (Objects.nonNull(sysQuery.getQueryCountSql())) {
            sqlCountBu = new StringBuilder(sysQuery.getQueryCountSql()).append(queryWhere);
        }

//       动态查询条件、前端参数进行动态拼接 -->>where cooperate_status = '1' and  dealer_name like '%苏州%' and dealer_mgr like '%何亚%';
        Map<String, String> wheres = generalQueryVo.getWheres();
        if (Objects.nonNull(boxheadSelectMap) && Objects.nonNull(wheres)) {
            for (Map.Entry<String, String> entry : wheres.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (Objects.isNull(value)) {
                    continue;
                }
                String selectType = boxheadSelectMap.get(key).toString();
                if (selectType.equals("like")) {
                    sqlBu.append(" and ").append(key).append(" like '%").append(value).append("%' ");
                    if (Objects.nonNull(sqlCountBu)) {
                        sqlCountBu.append(" and ").append(key).append(" like '%").append(value).append("%' ");
                    }
                }
            }
        }

        if (sysQuery.isQueryPage()) {
            generalQueryResponse = usePage(sysQuery, sqlBu, sqlCountBu);
        } else {
            generalQueryResponse = nonusePage(sysQuery, sqlBu);
        }
        return generalQueryResponse;
    }

    /**
     * 分页逻辑
     *
     * @param sysQuery 开窗SQL
     * @param sqlBu    查询语句
     * @return 结果
     */
    private GeneralQueryResponse usePage(SysQuery sysQuery, StringBuilder sqlBu, StringBuilder sqlCountBu) {
        if (Objects.isNull(sqlCountBu)){
            throw new WXLSQLException(ECode.SELECT_SQL_NULL_ERROR);
        }
        PageInfo pageInfo = TableSupport.pageInfo();
        sqlBu.append(" limit ").append(pageInfo.getSkipNum()).append(" , ").append(pageInfo.getPageSize());

        List<HashMap<String, Object>> objs = sysQueryMapper.queryTableDatas(sqlBu.toString());
        int total = sysQueryMapper.queryTotalCount(sqlCountBu.toString());
        pageInfo.setTotal(total);
        pageInfo.setRows(objs);

        return new GeneralQueryResponse().setBoxhead(JSONArray.parseArray(sysQuery.getBoxhead(), Map.class))
                .setQueryNum(sysQuery.getQueryNum())
                .setQueryDisplay(JSONArray.parseArray(sysQuery.getQueryDisplay(), Map.class))
                .setPageInfo(pageInfo);
    }

    /**
     * 未分页逻辑
     *
     * @param sysQuery 开窗SQL
     * @param sqlBu    查询语句
     * @return 结果
     */
    private GeneralQueryResponse nonusePage(SysQuery sysQuery, StringBuilder sqlBu) {
        List<HashMap<String, Object>> objs = sysQueryMapper.queryTableDatas(sqlBu.toString());
        List<Map> boxhead = JSONArray.parseArray(sysQuery.getBoxhead(), Map.class);
        return new GeneralQueryResponse().setBoxhead(boxhead)
                .setQueryNum(sysQuery.getQueryNum())
                .setQueryDisplay(JSONArray.parseArray(sysQuery.getQueryDisplay(), Map.class))
                .setRows(objs);
    }
}
