package com.sfa.system;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;

/**
 * 系统模块
 * 
 * @author ruoyi
 */
@EnableCustomConfig
@EnableRyFeignClients
@SpringBootApplication
@MapperScan("com.sfa.system.domain.mapper")
public class SfaSystemApplication
{
    public static void main(String[] args)
    {
        SpringApplication.run(SfaSystemApplication.class, args);
    }
}
