package com.sfa.system.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sfa.common.core.web.domain.BaseDo;
import com.sfa.common.core.web.domain.BaseEntity;
import lombok.Data;

/**
 * 开窗查询SQL
 * @TableName sys_query
 */
@TableName(value ="sys_query")
@Data
public class SysQuery extends BaseDo {
    /**
     * 开窗查询ID
     */
    @TableId(type = IdType.AUTO)
    private Long queryId;

    /**
     * 开窗名称
     */
    private String queryNum;

    /**
     * 查询名称
     */
    private String queryName;

    /**
     * 查询SQL
     */
    private String querySql;

    /**
     * 字段显示名称
     * 目前由前端控制
     */
    private String queryDisplay;

    /**
     * 默认查询条件
     */
    private String queryWhere;

    /**
     * 排序字段
     */
    private String queryOrder;

    /**
     * 是否需要limit n
     */
    private String queryLimit;

    /**
     * 当前sql是否分页
     */
    private boolean queryPage;

    /**
     * 表头栏中的样式
     */
    private String boxhead;

    /**
     * 表头栏查询
     */
    private String boxheadSelect;

    /**
     * 记录版本
     */
    private Integer flag;

    /**
     * 删除标记0 正常 1 删除
     */
    private String delFlag;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}