package com.sfa.system.domain.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalTime;

/**
 * 考勤规则对象 mdm_kq_rule
 *
 * @author admin
 * @date 2024-10-29
 */
@NoArgsConstructor
@AllArgsConstructor
@TableName(value ="mdm_kq_rule")
@Data
public class MdmKqRule extends BaseDo
{
    private static final long serialVersionUID = 1L;

    /** 规则ID */
    @TableId(type = IdType.AUTO)
    private Long ruleId;

    /** 规则编号 */
    private String ruleNum;

    /** 规则名称 */
    private String ruleName;

    /** 上班打卡允许开始时间 */
    private LocalTime firBegintime;

    /** 上班打卡允许结束时间 */
    private LocalTime firEndtime;

    /** 午班打卡允许开始时间 */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalTime secBegintime;

    /** 午班打卡允许结束时间 */
    private LocalTime secEndtime;

    /** 下班打卡允许开始时间 */
    private LocalTime thiBegintime;

    /** 下班打卡允许结束时间 */
    private LocalTime thiEndtime;

    /** 记录版本 */
    private Long flag;

    /** 删除标识 */
    private String delFlag;

}
