package com.sfa.system.service.core.impl;

import com.sfa.system.api.pojo.request.UserVo;
import com.sfa.system.api.pojo.response.SiteDto;
import com.sfa.system.domain.dao.IMdmCityDao;
import com.sfa.system.domain.dao.ISysPostDao;
import com.sfa.system.domain.dao.ISysUserDao;
import com.sfa.system.pojo.response.SysPostDto;
import com.sfa.system.service.core.ISysUserCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-30 17
 * @describe :
 */
@Service
public class SysUserCoreServiceImpl implements ISysUserCoreService {

    @Autowired
    ISysUserDao sysUserDao;
    @Autowired
    ISysPostDao sysPostDao;
    @Autowired
    IMdmCityDao mdmCityDao;

    @Override
    public void insertUser(UserVo userVo) {
        addCity(userVo);
        SysPostDto sysPostDto = sysPostDao.selectPostByPostCode(userVo.getPostCode());
//        关联岗位、考勤规则
        if (Objects.nonNull(sysPostDto)) {
            userVo.setPostCode(sysPostDto.getPostCode())
                    .setPostName(sysPostDto.getPostName())
                    .setRuleNum(sysPostDto.getRuleNum())
                    .setRuleName(sysPostDto.getRuleName());
        }
        sysUserDao.insertUser(userVo);
    }

    @Override
    public void updateUser(UserVo userVo) {
        sysUserDao.checkUserAllowed(userVo.getUserId());
        sysUserDao.checkUserDataScope(userVo.getUserId());
        addCity(userVo);
//        关联岗位、考勤规则
        SysPostDto sysPostDto = sysPostDao.selectPostByPostCode(userVo.getPostCode());
        if (Objects.nonNull(sysPostDto)) {
            userVo.setPostCode(sysPostDto.getPostCode())
                    .setPostName(sysPostDto.getPostName())
                    .setRuleNum(sysPostDto.getRuleNum())
                    .setRuleName(sysPostDto.getRuleName());
        }
        sysUserDao.updateUser(userVo);
    }

    // 补充角色、城市等信息
    private void addCity(UserVo userVo){
        if (Objects.isNull(userVo.getWorkCityNum())){
            return;
        }
        SiteDto siteDto = mdmCityDao.selectOneCity(userVo.getWorkProvinceNum(), userVo.getWorkCityNum());
        userVo.setWorkProvinceNum(siteDto.getProvinceNum())
                .setWorkProvinceName(siteDto.getProvinceName())
                .setWorkCityNum(siteDto.getCityNum())
                .setWorkCityName(siteDto.getCityName());
    }


}
