package com.sfa.system.domain.dao.impl;

import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.bean.BeanTransitions;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.system.api.domain.MdmCity;
import com.sfa.system.api.pojo.response.SiteDto;
import com.sfa.system.domain.dao.IMdmCityDao;
import com.sfa.system.domain.mapper.MdmCityMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-31 16
 * @describe :
 */
@Service
public class MdmCityDaoImpl implements IMdmCityDao {

    @Autowired
    MdmCityMapper mdmCityMapper;

    @Override
    public List<SiteDto> regionList(String provinceNum, String cityNum) {
        List<MdmCity> mdmCities = null;
        if (Objects.isNull(provinceNum) && Objects.isNull(cityNum)){
            mdmCities = mdmCityMapper.selectProvinces();
        }
        if (Objects.nonNull(provinceNum) && Objects.isNull(cityNum)){
            mdmCities = mdmCityMapper.selectCitys(provinceNum);
        }
        if (Objects.nonNull(cityNum)){
            mdmCities = mdmCityMapper.selectCountys(cityNum);
        }
        return BeanUtils.transitionDtos(mdmCities, SiteDto.class);
    }

    @Override
    public SiteDto selectOneCity(String provinceNum, String cityNum) {
        if (Objects.isNull(cityNum)){
            throw new CheckedException(ECode.PARAM_CODE_ISNULL_ERROR,"城市");
        }
        MdmCity cityDo = mdmCityMapper.selectOneCity(provinceNum,cityNum);

        return BeanUtils.transitionDto(cityDo, SiteDto.class);
    }


}
