package com.sfa.system.service.query.impl;

import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.system.api.pojo.request.UserVo;
import com.sfa.system.api.pojo.response.UserDto;
import com.sfa.system.domain.dao.ISysUserDao;
import com.sfa.system.domain.dao.ISysUserProDao;
import com.sfa.system.domain.wq.SysUserWq;
import com.sfa.system.pojo.response.SysUserProDto;
import com.sfa.system.service.query.IUserQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-10-31 13
 * @describe :
 */
@Service
public class UserQueryServiceImpl implements IUserQueryService {

    @Autowired
    private ISysUserDao userDao;
    @Autowired
    private ISysUserProDao sysUserProDao;

    /**
     * 分页查询
     */
    @Override
    public PageInfo selectUserPage(UserVo userVo) {
        SysUserWq sysUserWq = new SysUserWq();
        BeanUtils.copyProperties(userVo,sysUserWq);
        sysUserWq.setUserNameLike(userVo.getUserName())
                .setPhonenumberLike(userVo.getPhonenumber());

        return userDao.selectUserPage(sysUserWq);
    }

    @Override
    public SysUserProDto selectUserPromotion(UserDto userDto) {
        return sysUserProDao.selectOne(userDto.getUserName());
    }
}
