package com.sfa.system.controller.query;

import com.sfa.common.security.annotation.InnerAuth;
import com.sfa.system.api.pojo.response.SiteDto;
import com.sfa.system.service.query.ISiteQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-31 16
 * @describe : 关于地点/区域/位置等查询信息
 */
@RestController
@RequestMapping("/site/query")
public class SiteQueryController {

    @Autowired
    ISiteQueryService siteQueryService;

    /**
     * region:行政区域查询
     */
    @GetMapping("/region")
    public List<SiteDto> regionList(String provinceNum,String cityNum){
        return siteQueryService.regionList(provinceNum,cityNum);
    }

    @InnerAuth
    @PostMapping("/county")
    public SiteDto getCountyName(@RequestBody SiteDto siteDto){
        return siteQueryService.getCountyName(siteDto.getProvinceName(),siteDto.getCityName(),siteDto.getCountyName());
    }
}
