package com.sfa.system.service.core.impl;

import com.sfa.system.domain.dao.IMdmKqRuleDao;
import com.sfa.system.domain.wq.MdmKqRuleWq;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;
import com.sfa.system.service.core.IMdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@Service
public class IMdmKqRuleServiceImpl implements IMdmKqRuleService {

    @Autowired
    IMdmKqRuleDao IMdmKqRuleDao;

    @Override
    public List<MdmKqRuleDto> selectMdmKqRuleList(MdmKqRuleVo ruleVo) {
        MdmKqRuleWq mdmKqRuleWq = new MdmKqRuleWq().setRuleNameLike(ruleVo.getRuleName()).setCreateByLike(ruleVo.getCreateBy());
        return IMdmKqRuleDao.selectMdmKqRuleList(mdmKqRuleWq);
    }

    @Override
    public MdmKqRuleDto selectMdmKqRuleByRuleId(Long ruleId) {
        return IMdmKqRuleDao.selectMdmKqRuleByRuleId(ruleId);
    }

    @Override
    public void insertMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        IMdmKqRuleDao.insertMdmKqRule(mdmKqRuleVo);
    }

    @Override
    public void updateMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        IMdmKqRuleDao.updateMdmKqRule(mdmKqRuleVo);
    }
}
