package com.sfa.system.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.system.domain.dao.MdmKqRuleDao;
import com.sfa.system.domain.entity.MdmKqRule;
import com.sfa.system.domain.mapper.MdmKqRuleMapper;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@Service
public class IMdmKqRuleDao implements MdmKqRuleDao {
    @Autowired
    private MdmKqRuleMapper mdmKqRuleMapper;

    /**
     * 查询考勤规则
     *
     * @param ruleId 考勤规则主键
     * @return 考勤规则
     */
    @Override
    public MdmKqRuleDto selectMdmKqRuleByRuleId(Long ruleId) {
        MdmKqRule mdmKqRule = mdmKqRuleMapper.selectById(ruleId);
        return transitionDto(mdmKqRule);
    }

    /**
     * 查询考勤规则列表
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 考勤规则
     */
    @Override
    public List<MdmKqRuleDto> selectMdmKqRuleList(MdmKqRuleVo mdmKqRuleVo) {
        List<MdmKqRule> mdmKqRules = mdmKqRuleMapper.selectList(new QueryWrapper<>());
        return transitionDtos(mdmKqRules);
    }

    /**
     * 新增考勤规则
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 结果
     */
    @Override
    public int insertMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        try {
            MdmKqRule mdo = new MdmKqRule();
            BeanUtils.copyProperties(mdmKqRuleVo, mdo);
            return mdmKqRuleMapper.insert(mdo);
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'mdm_kq_rule_unique'")) {
                throw new WXLSQLException(ECode.API_ERROR, "考勤编码");
            }
            return -1;
        }
    }

    /**
     * 修改考勤规则
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 结果
     */
    @Override
    public int updateMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        try {
            MdmKqRule mdo = new MdmKqRule();
            BeanUtils.copyProperties(mdmKqRuleVo, mdo);
            return mdmKqRuleMapper.updateById(mdo);
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'mdm_kq_rule_unique'")) {
                throw new WXLSQLException(ECode.API_ERROR, "考勤编码");
            }
            return -1;
        }
    }

    /**
     * 批量删除考勤规则
     *
     * @param ruleIds 需要删除的考勤规则主键
     * @return 结果
     */
    @Override
    public int deleteMdmKqRuleByRuleIds(Long[] ruleIds) {
        return mdmKqRuleMapper.deleteMdmKqRuleByRuleIds(ruleIds);
    }

    /**
     * 删除考勤规则信息
     *
     * @param ruleId 考勤规则主键
     * @return 结果
     */
    @Override
    public int deleteMdmKqRuleByRuleId(Long ruleId) {
        return mdmKqRuleMapper.deleteMdmKqRuleByRuleId(ruleId);
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param mdos DO对象List
     * @return DTO对象
     */
    private List<MdmKqRuleDto> transitionDtos(List<MdmKqRule> mdos) {
        if (CollectionUtils.isEmpty(mdos)) {
            return new ArrayList<>();
        }

        List<MdmKqRuleDto> dtos = new ArrayList<>(mdos.size() * 2);
        for (MdmKqRule mdo : mdos) {
            dtos.add(transitionDto(mdo));
        }
        return dtos;
    }

    private MdmKqRuleDto transitionDto(MdmKqRule mdo) {
        MdmKqRuleDto dto = null;
        if (Objects.isNull(mdo)) {
            return dto;
        }
        dto = new MdmKqRuleDto();
        BeanUtils.copyProperties(mdo, dto);
        return dto;
    }

}
