package com.sfa.system.domain.dao;

import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
public interface MdmKqRuleDao {

    /**
     * 查询考勤规则
     *
     * @param ruleId 考勤规则主键
     * @return 考勤规则
     */
    public MdmKqRuleDto selectMdmKqRuleByRuleId(Long ruleId);

    /**
     * 查询考勤规则列表
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 考勤规则集合
     */
    public List<MdmKqRuleDto> selectMdmKqRuleList(MdmKqRuleVo mdmKqRuleVo);

    /**
     * 新增考勤规则
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 结果
     */
    public int insertMdmKqRule(MdmKqRuleVo mdmKqRuleVo);

    /**
     * 修改考勤规则
     *
     * @param mdmKqRuleVo 考勤规则
     * @return 结果
     */
    public int updateMdmKqRule(MdmKqRuleVo mdmKqRuleVo);

    /**
     * 批量删除考勤规则
     *
     * @param ruleIds 需要删除的考勤规则主键集合
     * @return 结果
     */
    public int deleteMdmKqRuleByRuleIds(Long[] ruleIds);

    /**
     * 删除考勤规则信息
     *
     * @param ruleId 考勤规则主键
     * @return 结果
     */
    public int deleteMdmKqRuleByRuleId(Long ruleId);
}
