package com.sfa.system.controller.tencentquery;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.system.utils.TencentLbsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-09-05 11
 * @describe : 腾讯地图查询
 */
@RestController
@RequestMapping("/tencent/lbs")
public class LbsQueryController {

    @Autowired
    private TencentLbsUtil tencentLbsUtil;
    /**
     * 根据经纬度查询地址
     * @param location 经纬度
     * @return 地址
     */
    @GetMapping("/address")
    public JSONObject addressByLocation(String location) {
       return tencentLbsUtil.addressByLocation(location);
    }


}
