package com.sfa.system.controller.query;

import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;
import com.sfa.system.service.core.IMdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalTime;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-04 11
 * @describe :
 */
@RestController
@RequestMapping("/kq_rule")
public class KqRuleQueryController extends BaseController {
    @Autowired
    private IMdmKqRuleService mdmKqRuleService;

    /**
     * 查询考勤规则列表
     */
//    todo @RequiresPermissions("gen:rule:list")
    @PostMapping("/list")
    public List<MdmKqRuleDto> list(@RequestBody MdmKqRuleVo mdmKqRuleVo) {
        return mdmKqRuleService.selectMdmKqRuleList(mdmKqRuleVo);
    }

//    /**
//     * 导出考勤规则列表
//     */
//    @RequiresPermissions("gen:rule:export")
//    @Log(title = "考勤规则", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, MdmKqRuleVo mdmKqRuleVo)
//    {
//        List<MdmKqRuleVo> list = mdmKqRuleService.selectMdmKqRuleList(mdmKqRule);
//        ExcelUtil<MdmKqRule> util = new ExcelUtil<MdmKqRule>(MdmKqRule.class);
//        util.exportExcel(response, list, "考勤规则数据");
//    }

    /**
     * 获取考勤规则详细信息
     */
//    todo @RequiresPermissions("gen:rule:query")
    @GetMapping(value = "/{ruleId}")
    public MdmKqRuleDto getInfo(@PathVariable("ruleId") Long ruleId) {
        MdmKqRuleDto mdmKqRuleDto = mdmKqRuleService.selectMdmKqRuleByRuleId(ruleId);
        mdmKqRuleDto.setCurrently(LocalTime.now());
        return mdmKqRuleDto;
    }
}
