package com.sfa.system.service.core.impl;

import com.sfa.system.domain.dao.MdmKqRuleDao;
import com.sfa.system.domain.entity.MdmKqRule;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;
import com.sfa.system.service.core.MdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@Service
public class IMdmKqRuleService implements MdmKqRuleService {

    @Autowired
    MdmKqRuleDao mdmKqRuleDao;

    @Override
    public List<MdmKqRuleDto> selectMdmKqRuleList(MdmKqRuleVo mdmKqRuleVo) {
        return mdmKqRuleDao.selectMdmKqRuleList(mdmKqRuleVo);
    }

    @Override
    public MdmKqRuleDto selectMdmKqRuleByRuleId(Long ruleId) {
        return mdmKqRuleDao.selectMdmKqRuleByRuleId(ruleId);
    }

    @Override
    public void insertMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        mdmKqRuleDao.insertMdmKqRule(mdmKqRuleVo);
    }

    @Override
    public void updateMdmKqRule(MdmKqRuleVo mdmKqRuleVo) {
        mdmKqRuleDao.updateMdmKqRule(mdmKqRuleVo);
    }
}
