package com.sfa.system.domain.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.sfa.system.domain.entity.MdmKqRule;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;



/**
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@Repository
@Mapper
public interface MdmKqRuleMapper extends BaseMapper<MdmKqRule> {
    /**
     * 查询考勤规则
     *
     * @param ruleId 考勤规则主键
     * @return 考勤规则
     */
    public MdmKqRule selectMdmKqRuleByRuleId(Long ruleId);

    /**
     * 查询考勤规则列表
     *
     * @param mdmKqRule 考勤规则
     * @return 考勤规则集合
     */
    public List<MdmKqRule> selectMdmKqRuleList(MdmKqRule mdmKqRule);

    /**
     * 新增考勤规则
     *
     * @param mdmKqRule 考勤规则
     * @return 结果
     */
    public int insertMdmKqRule(MdmKqRule mdmKqRule);

    /**
     * 修改考勤规则
     *
     * @param mdmKqRule 考勤规则
     * @return 结果
     */
    public int updateMdmKqRule(MdmKqRule mdmKqRule);

    /**
     * 删除考勤规则
     *
     * @param ruleId 考勤规则主键
     * @return 结果
     */
    public int deleteMdmKqRuleByRuleId(Long ruleId);

    /**
     * 批量删除考勤规则
     *
     * @param ruleIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdmKqRuleByRuleIds(Long[] ruleIds);
}
