package com.sfa.system.controller.core;


import java.util.List;

import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.pojo.response.MdmKqRuleDto;
import com.sfa.system.service.core.MdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.core.web.controller.BaseController;

/**
 * 考勤规则Controller
 *
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@RestController
@RequestMapping("/kq_rule")
public class KqRuleCoreController extends BaseController {
    @Autowired
    private MdmKqRuleService mdmKqRuleService;

    /**
     * 查询考勤规则列表
     */
    @RequiresPermissions("gen:rule:list")
    @GetMapping("/list")
    public List<MdmKqRuleDto> list(MdmKqRuleVo mdmKqRuleVo) {
        return mdmKqRuleService.selectMdmKqRuleList(mdmKqRuleVo);
    }

//    /**
//     * 导出考勤规则列表
//     */
//    @RequiresPermissions("gen:rule:export")
//    @Log(title = "考勤规则", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, MdmKqRuleVo mdmKqRuleVo)
//    {
//        List<MdmKqRuleVo> list = mdmKqRuleService.selectMdmKqRuleList(mdmKqRule);
//        ExcelUtil<MdmKqRule> util = new ExcelUtil<MdmKqRule>(MdmKqRule.class);
//        util.exportExcel(response, list, "考勤规则数据");
//    }

    /**
     * 获取考勤规则详细信息
     */
    @RequiresPermissions("gen:rule:query")
    @GetMapping(value = "/{ruleId}")
    public MdmKqRuleDto getInfo(@PathVariable("ruleId") Long ruleId) {
        return mdmKqRuleService.selectMdmKqRuleByRuleId(ruleId);
    }

    /**
     * 新增考勤规则
     */
    @RequiresPermissions("gen:rule:add")
    @Log(title = "考勤规则", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public void add(@RequestBody @Validated MdmKqRuleVo mdmKqRuleVo) {
        mdmKqRuleService.insertMdmKqRule(mdmKqRuleVo);
    }

    /**
     * 修改考勤规则
     */
    @RequiresPermissions("gen:rule:edit")
    @Log(title = "考勤规则", businessType = BusinessType.UPDATE)
    @PutMapping("/put")
    public void edit(@RequestBody @Validated MdmKqRuleVo mdmKqRuleVo) {
        mdmKqRuleService.updateMdmKqRule(mdmKqRuleVo);
    }

//    /**
//     * 删除考勤规则
//     */
//    @RequiresPermissions("gen:rule:remove")
//    @Log(title = "考勤规则", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ruleIds}")
//    public AjaxResult remove(@PathVariable Long[] ruleIds)
//    {
//        return toAjax(mdmKqRuleService.deleteMdmKqRuleByRuleIds(ruleIds));
//    }
}