package com.sfa.system.controller.core;


import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.system.pojo.request.MdmKqRuleVo;
import com.sfa.system.service.core.IMdmKqRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 考勤规则Controller
 *
 * @author : liqiulin
 * @date : 2024-10-29 14
 * @describe :
 */
@RestController
@RequestMapping("/kq_rule")
public class KqRuleCoreController extends BaseController {
    @Autowired
    private IMdmKqRuleService mdmKqRuleService;


    /**
     * 新增考勤规则
     */
    @RequiresPermissions("system:kq_rule:list")
    @Log(title = "考勤规则", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public void add(@RequestBody @Validated MdmKqRuleVo mdmKqRuleVo) {
        Long userId = SecurityUtils.getUserId();
        String username = SecurityUtils.getUsername();
        mdmKqRuleVo.setCreateBy(username);
        mdmKqRuleVo.setCreateUserId(userId);
        mdmKqRuleService.insertMdmKqRule(mdmKqRuleVo);
    }

    /**
     * 修改考勤规则
     */
    @RequiresPermissions("system:kq_rule:list")
    @Log(title = "考勤规则", businessType = BusinessType.UPDATE)
    @PutMapping("/put")
    public void edit(@RequestBody MdmKqRuleVo mdmKqRuleVo) {
        Long userId = SecurityUtils.getUserId();
        String username = SecurityUtils.getUsername();
        mdmKqRuleVo.setUpdateBy(username);
        mdmKqRuleVo.setUpdateUserId(userId);
        mdmKqRuleService.updateMdmKqRule(mdmKqRuleVo);
    }

//    /**
//     * 删除考勤规则
//     */
//    @RequiresPermissions("gen:rule:remove")
//    @Log(title = "考勤规则", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ruleIds}")
//    public AjaxResult remove(@PathVariable Long[] ruleIds)
//    {
//        return toAjax(mdmKqRuleService.deleteMdmKqRuleByRuleIds(ruleIds));
//    }
}