package com.sfa.operation.controller.basedata.query;

import com.sfa.operation.pojo.basedata.response.BaseProductDto;
import com.sfa.operation.service.basedata.IBaseProductService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-10-30 14
 * @describe : 产品主数据
 */
@RestController
@RequestMapping("/base/product")
public class BaseProductQueryController {
    @Autowired
    private IBaseProductService baseProductService;
    @GetMapping("/{proCode}")
    public BaseProductDto getByProCode(@PathVariable("proCode") String proCode){
       return baseProductService.getByProCode(proCode);
    }
}
