package com.sfa.operation.service.risk.impl;

import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.operation.domain.risk.dao.IRiskStoreTaskDao;
import com.sfa.operation.domain.risk.wq.RiskStoreTaskWq;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskPageListVo;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreTaskQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-08-28 16
 * @describe :
 */
@Service
public class RiskStoreTaskQueryServiceImpl implements IRiskStoreTaskQueryService {
    @Autowired
    private IRiskStoreTaskDao riskStoreTaskDao;
    @Override
    public PageInfo page(RiskStoreTaskPageListVo riskStoreTaskVo) {
        RiskStoreTaskWq wq = new RiskStoreTaskWq();
        wq.setOperEmpNo(riskStoreTaskVo.getOperEmpNo());
        wq.setStoreName(riskStoreTaskVo.getStoreName());
        wq.setOperDateStart(riskStoreTaskVo.getOperDateStart());
        wq.setOperDateEnd(riskStoreTaskVo.getOperDateEnd());
        return riskStoreTaskDao.page(wq);
    }

    @Override
    public RiskStoreTaskDto getDetail(RiskStoreTaskVo riskStoreTaskVo) {
        RiskStoreTaskWq wq = new RiskStoreTaskWq();
        BeanUtils.copyProperties(riskStoreTaskVo, wq);
        return riskStoreTaskDao.selectOne(wq);
    }
}
