package com.sfa.operation.service.risk.impl;

import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.risk.dao.IRiskStoreDao;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskInspectStoreDto;
import com.sfa.operation.service.risk.IRiskStoreCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-08-28 17
 * @describe :风控门店操作 - 此service针对风控门店的所有增删改操作
 */
@Service
public class RiskStoreCoreServiceImpl implements IRiskStoreCoreService {
    @Autowired
    private IRiskStoreDao riskStoreDao;
    @Override
    public RiskInspectStoreDto saveInspectStore(RiskStoreTaskVo riskStoreTaskVo) {
        RiskInspectStoreDto storeDto = BeanUtils.transitionDto(riskStoreTaskVo, RiskInspectStoreDto.class);
        storeDto.setStorePictures(riskStoreTaskVo.getStorePicture());
        return riskStoreDao.insert(storeDto);
    }
}
