package com.sfa.operation.pojo.risk.request;

import cn.hutool.core.date.DateUtil;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe :
 */
@Data
public class RiskStoreTaskPageListVo {

    /**
     * --------    门店信息    --------
     */
    private String storeName;

    private String operEmpNo;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date operDateStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date operDateEnd;


    public Date getOperDateStart() {
        // 如果为空 默认是当月的1号
        if (operDateStart == null) {
            operDateStart = DateUtil.beginOfMonth(new Date());
        }
        return operDateStart;
    }
    public Date getOperDateEnd() {
        // 如果为空 默认是当月的最后一天
        if (operDateEnd == null) {
            operDateEnd = DateUtil.endOfMonth(new Date());
        }
        return operDateEnd;
    }
}
