package com.sfa.operation.domain.sales.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 营销中心-活动计划-档期陈列（计划+执行）
 * @TableName sales_ap_promotion_display
 */
@TableName(value ="sales_ap_promotion_display")
@Data
public class SalesApPromotionDisplay implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long sapdId;
    private Date salesMonth;

    /**
     * 销售大区
     */
    private String regionName;

    /**
     * 销售战区
     */
    private String districtName;

    /**
     * 经销商-省份
     */
    private String dealerProvince;

    /**
     * 经销商-城市
     */
    private String dealerCity;

    /**
     * 经销商-代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 开户日期
     */
    private Date openingDate;

    /**
     * 闭户日期
     */
    private Date closingDate;

    /**
     * 大区总监
     */
    private String regionManager;

    /**
     * 战区经理
     */
    private String districtManager;

    /**
     * 城市经理
     */
    private String cityManager;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 系统类型
     */
    private String lineType;

    /**
     * 渠道大类
     */
    private String channelDl;

    /**
     * 渠道小类
     */
    private String channelXl;

    /**
     * 系统业态
     */
    private String lineLf;

    /**
     * 门店数
     */
    private String storeCount;

    /**
     * 档期执行月份
     */
    private String promotionExecutionMonth;

    /**
     * 档期计划-促销规格
     */
    private String plannedPromotionSpec;

    /**
     * 档期计划-促销口味
     */
    private String plannedPromotionFlavor;

    /**
     * 计划-档期规则
     */
    private String plannedPromotionRules;

    /**
     * 计划-档期前补差天数
     */
    private Integer plannedPrePromotionAdjustDays;

    /**
     * 计划-档期后补差天数
     */
    private Integer plannedPostPromotionAdjustDays;

    /**
     * 计划-档期开始时间
     */
    private Date plannedPromotionStartDate;

    /**
     * 计划-补差开始时间
     */
    private Date plannedAdjustmentStartDate;

    /**
     * 计划-档期结束时间
     */
    private Date plannedPromotionEndDate;

    /**
     * 计划-补差结束时间
     */
    private Date plannedAdjustmentEndDate;

    /**
     * 计划-档期陈列开始时间
     */
    private Date plannedPromotionDisplayStartDate;

    /**
     * 计划-档期陈列结束时间
     */
    private Date plannedPromotionDisplayEndDate;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 门店计数
     */
    private String storeCountNum;

    /**
     * 门店地址
     */
    private String storeAddress;

    /**
     * 计划端架-数量
     */
    private Double plannedEndCapQty;

    /**
     * 计划端架-费用
     */
    private BigDecimal plannedEndCapTotalCost;

    /**
     * 实际端架-数量
     */
    private Double actualEndCapQty;

    /**
     * 实际端架-是否执行
     * 端架目标网点数>=1时，为执行/未执行
     */
    private String actualEndCapExecuted;

    /**
     * 计划地堆-平米数（㎡）
     */
    private Double plannedFloorStackArea;

    /**
     * 计划地堆-数量
     */
    private Integer plannedFloorStackQty;

    /**
     * 计划地堆-费用
     */
    private BigDecimal plannedFloorStackTotalCost;

    /**
     * 实际地堆-平米数（㎡）
     */
    private Double actualFloorStackArea;

    /**
     * 实际地堆-数量
     */
    private Integer actualFloorStackQty;

    /**
     * 实际地堆是否执行
     * 地堆目标网点数>=1时，为执行/未执行
     */
    private String actualFloorStackExecuted;

    /**
     * 计划其他陈列数量+形式
     */
    private String plannedOtherDisplay;

    /**
     * 计划其他陈列-总费用
     */
    private BigDecimal plannedOtherDisplayTotalCost;

    /**
     * 实际其他陈列-数量+形式
     */
    private String actualOtherDisplay;

    /**
     * 实际其他陈列-是否执行
     * 其他陈列目标网点数>=1时，为执行/未执行
     */
    private String actualOtherDisplayExecuted;

    /**
     * 合计费用-费用
     */
    private BigDecimal totalCost;

    /**
     * 档期陈列是否执行
     */
    private String promotionDisplayExecuted;

    /**
     * 付费陈列- 是否
     */
    private String paidDisplay;

    /**
     * 当月拜访目标-是否
     */
    private String monthlyVisitTarget;

    /**
     * 实际是否拜访
     */
    private String monthlyVisited;
    private Date createTime;
    private String updateBy;
    private Date updateTime;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}