package com.sfa.operation.domain.risk.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.risk.dao.IRiskStoreDao;
import com.sfa.operation.domain.risk.entity.RiskInspectStore;
import com.sfa.operation.domain.risk.mapper.RiskInspectStoreMapper;
import com.sfa.operation.pojo.risk.response.RiskInspectStoreDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-08-28 17
 * @describe :
 */
@DS("bi")
@Service
public class RiskStoreDaoImpl implements IRiskStoreDao {
    @Autowired
    private RiskInspectStoreMapper riskInspectStoreMapper;
    @Override
    public RiskInspectStoreDto insert(RiskInspectStoreDto storeDto) {
        RiskInspectStore storeDo = BeanUtils.transitionDto(storeDto, RiskInspectStore.class);
        try {
            riskInspectStoreMapper.save(storeDo);
            return storeDto;
        }catch (Exception e){
            String eMsg = e.getCause().getMessage();
            if (!eMsg.contains("for key 'store_code_unique'")) {
                throw new WXLSQLException(ECode.DB_TABLE_UPDATE_ERROR);
            }
            LambdaUpdateWrapper<RiskInspectStore> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(RiskInspectStore::getStoreCode, storeDo.getStoreCode());
            riskInspectStoreMapper.update(storeDo,updateWrapper);
            RiskInspectStore riskInspectStore = riskInspectStoreMapper.selectOne(new LambdaQueryWrapper<RiskInspectStore>().eq(RiskInspectStore::getStoreCode, storeDo.getStoreCode()));
            return BeanUtils.transitionDto(riskInspectStore, RiskInspectStoreDto.class);
        }
    }
}
