package com.sfa.operation.service.promotion.impl;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.enums.promotion.PlanStatus;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.operation.domain.promotion.dao.IActivityPlanApprovalDao;
import com.sfa.operation.domain.promotion.dao.IActivityPlanInfoDao;
import com.sfa.operation.domain.promotion.wq.ActivityPlanWq;
import com.sfa.operation.pojo.promotion.request.ActivityPlanApprovalDto;
import com.sfa.operation.pojo.promotion.request.ActivityPlanInfoDto;
import com.sfa.operation.service.promotion.ICpPlanQueryService;
import com.sfa.system.api.RemoteUserService;
import com.sfa.system.api.domain.SysUser;
import com.sfa.system.api.model.LoginUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-05-29 10
 * @describe :
 */
@Service
public class CpPlanQueryServiceImpl implements ICpPlanQueryService {

    @Value("${feishu.approval.scfy}")
    private String scfyCode;
    @Autowired
    private IActivityPlanInfoDao activityPlanInfoDao;
    @Autowired
    private IActivityPlanApprovalDao activityPlanApprovalDao;
    @Autowired
    private RemoteUserService remoteUserService;
    @Autowired
    private FeiShuUtil feiShuUtil;

    @Override
    public List<String> createApproval(int year,int month) {
        // 计划文件ID下未审批数据
        ActivityPlanWq qw = new ActivityPlanWq();
        qw.setYear(year).setMonth(month).setPlanStatus(PlanStatus.WAIT.getCode());

        List<ActivityPlanInfoDto> infos = activityPlanInfoDao.findList(qw);
        if (CollectionUtils.isEmpty(infos)){
            throw new CheckedException(ECode.DATA_NULL_ERROR);
        }

        /**
         * 分员工处理
         */
        Map<String, List<ActivityPlanInfoDto>> planGroupByEmp = infos.stream().collect(Collectors.groupingBy(ActivityPlanInfoDto::getEmployeeNo));
        for (Map.Entry<String, List<ActivityPlanInfoDto>> entry : planGroupByEmp.entrySet()) {
            String empNo = entry.getKey();
            List<ActivityPlanInfoDto> plans = entry.getValue();
            ActivityPlanApprovalDto approvalDto = createFsApproval(empNo, plans);
            // 修改activity_approval_info表中，涉及到id的状态
            activityPlanInfoDao.updatePlanStatus(approvalDto);
        }
        return null;
    }


    private ActivityPlanApprovalDto createFsApproval(String empNo,List<ActivityPlanInfoDto> plans){
//todo        R<LoginUser> userR = remoteUserService.getUserInfo(empNo, SecurityConstants.INNER);
        R<LoginUser> userR = remoteUserService.getUserInfo("000516", SecurityConstants.INNER);
        SysUser userInfo = userR.getData().getSysUser();

        List<Long> planIds = plans.stream().map(plan -> plan.getId()).collect(Collectors.toList());
        Map<String, List<ActivityPlanInfoDto>> planGroupByDealer = plans.stream().collect(Collectors.groupingBy(ActivityPlanInfoDto::getDealerName));

        List<List> values = new ArrayList();
        for (Map.Entry<String, List<ActivityPlanInfoDto>> entry : planGroupByDealer.entrySet()) {
            String dealerName = entry.getKey();
            List<ActivityPlanInfoDto> plans2 = entry.getValue();

            Set<String> lineName = new HashSet<>();
            Set<String> stores = new HashSet<>();
            AtomicReference<BigDecimal> salaryTotal = new AtomicReference<>(BigDecimal.ZERO);
            AtomicReference<BigDecimal>  incidentalsTotal = new AtomicReference<>(BigDecimal.ZERO);

            plans2.forEach(plan -> {
                lineName.add(plan.getLineName());
                stores.add(plan.getStoreName());
                salaryTotal.set(salaryTotal.get().add(plan.getSalary()));
                incidentalsTotal.set(incidentalsTotal.get().add(plan.getIncidentals()));
            });

            // 组装from表单value值
            List<Map> fromValues = new ArrayList();
            // 经销商
            Map<String,Object> value1 = new HashMap<>();
            value1.put("id","widget17482494846610001");
            value1.put("type","input");
            value1.put("value",dealerName);
            // 系统名称
            Map<String,Object> value2 = new HashMap<>();
            value2.put("id","widget17482495216610001");
            value2.put("type","textarea");
            value2.put("value", StringUtils.join(lineName,"\n"));
            // 门店数
            Map<String,Object> value3 = new HashMap<>();
            value3.put("id","widget17482483392700001");
            value3.put("type","number");
            value3.put("value", stores.size());
            // 场次数
            Map<String,Object> value4 = new HashMap<>();
            value4.put("id","widget17482483806210001");
            value4.put("type","number");
            value4.put("value", plans2.size());
            // 合计工资
            Map<String,Object> value5 = new HashMap<>();
            value5.put("id","widget17482484113200001");
            value5.put("type","amount");
            value5.put("value", salaryTotal.get());
            // 合计杂费
            Map<String,Object> value6 = new HashMap<>();
            value6.put("id","widget17482484117210001");
            value6.put("type","amount");
            value6.put("value", incidentalsTotal.get());
            fromValues.add(value1);
            fromValues.add(value2);
            fromValues.add(value3);
            fromValues.add(value4);
            fromValues.add(value5);
            fromValues.add(value6);
            values.add(fromValues);
        }
        String ar = pushFrom(values, userInfo);
        ActivityPlanApprovalDto approvalDto = JSONObject.parseObject(ar, ActivityPlanApprovalDto.class);

        approvalDto.setPlanInfoIds(JSONObject.toJSONString(planIds))
                .setPlanMonth(DateUtils.parseDateToStr(DateUtils.YYYY_MM, new Date()))
                .setEmployeeName(userInfo.getNickName())
                .setEmployeeNo(userInfo.getUserName())
                .setApprovalStatus(PlanStatus.PENDING)
                .setCreateBy(userInfo.getNickName())
                .setPlanInfoIdList(planIds);
        activityPlanApprovalDao.save(approvalDto);

        return approvalDto;
    }

    /**
     * 市场推广费用申请（审批实例CODE：258B4D93-96D4-49E4-B9E1-DA6AB45740B0）
     */
    private String pushFrom(List<List> fromValues,SysUser userInfo) {
        // 提交人
        Map<String,Object> fromMap1 = new HashMap<>();
        fromMap1.put("id","widget17491191360290001");
        fromMap1.put("type","input");
        fromMap1.put("value",userInfo.getNickName()+"（"+userInfo.getUserName()+"）");
        // CP活动月份
        Map<String,Object> fromMap2 = new HashMap<>();
        fromMap2.put("id","widget17491191565410001");
        fromMap2.put("type","input");
        fromMap2.put("value",DateUtils.parseDateToStr(DateUtils.YYYY_MM, DateUtils.toDate(LocalDate.now().plusMonths(1))));
        // form表单值(明细表)
        Map<String,Object> fromMap3 = new HashMap<>();
        fromMap3.put("id","widget17482491805280001");
        fromMap3.put("type","fieldList");
        fromMap3.put("value",fromValues);

        // 审批实例
        Map<String,Object> approval = new HashMap<>();
        approval.put("form",Arrays.asList(fromMap1,fromMap2,fromMap3));
        approval.put("approval_code",scfyCode);
//todo        approval.put("user_id",userInfo.getFsUserId());
        approval.put("user_id","ge59e787");
        approval.put("allow_resubmit",false);
        approval.put("allow_submit_again",false);

        // 使用王小卤链路中心应用提交审批
        String approvalCode = feiShuUtil.createApproval(approval);

        // 根据code查询审批详情
        return feiShuUtil.getApprovalInfo(approvalCode);
    }
}
