package com.sfa.operation.pojo.sales.vo;

import lombok.Data;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-10 15:31
 * @Description: 店内执行-填报要更新到表的字段
 */
@Data
public class SalesApDisplayVo {
    /**
     * 主键ID
     */
    private Long sadId;

    /**
     * 主货架形式（实际）
     */
    private String actualMainShelfType;

    /**
     * 主货架数量（实际）
     */
    private Integer actualMainShelfQty;

    /**
     * 实际-主货架是否执行
     * 执行主货架形式 >= 计划主货架形式 && 执行主货架数量 >= 计划主货架数量"
     * 执行/未执行
     */
    private String actualMainShelfExecuted;

    /**
     * 端架数量（实际）
     */
    private Integer actualEndCapQty;

    /**
     * 实际-架是否执行
     * 执行端架数量 >= 计划端架数量
     */
    private String actualEndCapExecuted;

    /**
     * 地堆平米数（实际）
     */
    private Double actualFloorStackArea;

    /**
     * 地堆数量（实际）
     */
    private Integer actualFloorStackQty;

    /**
     * 实际-地堆是否执行
     * 执行平米数 >= 计划平米数 && 执行数量 >= 计划数量"
     */
    private String actualFloorStackExecuted;

    /**
     * 多点陈列数量+形式（实际）
     */
    private String actualMultiDisplay;

    /**
     * 实际-多点陈列是否执行
     *
     * actualMultiDisplay的值如下时：
     * 执行与计划一致：执行
     * 执行与计划不一致：未执行
     */
    private String actualMultiDisplayExecuted;
    /**
     * 挂条数量+形式（实际）
     */
    private String actualHangingStripQuantityForm;

    /**
     * 实际-挂条是否执行
     *
     * actualHangingStripQuantityForm的值如下时：
     * 执行与计划一致：执行
     * 执行与计划不一致：未执行
     */
    private String hangingStripExecuted;

    /**
     * 备注信息
     *
     */
    private String remark ;
}
