package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresRoles;
import com.sfa.common.security.annotation.SalesPermissionCheck;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-12-01 15
 * @describe :
 */
@RestController
@RequestMapping("/sales/ap_report/query")
public class APReportQueryController {
    @Autowired
    private IApDisplayQueryService apDisplayQueryService;
    /**
     * 店内执行-城市经理
     */
    @GetMapping("/store_cm")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public Object queryStoreAPReport(SalesApRequest request) {
        return apDisplayQueryService.queryStoreAPReport(request);
    }

    /**
     * 店内执行-大区/战区
     */
    @GetMapping("/dept_cm")
    @RequiresRoles(value = {RoleConstants.OPERATION_CENTER_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.DEPT)
    public Object queryDeptAPReport(SalesApRequest request) {
        return apDisplayQueryService.queryDeptAPReport(request);
    }

    /**
     * 店内执行-经销商维度
     */
    @GetMapping("/dist_cm")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public Object queryDistAPReport(SalesApRequest request) {
        return apDisplayQueryService.queryDistAPReport(request);
    }

}
