package com.sfa.operation.enums;

import lombok.Getter;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-10 16:15
 * @Description: 店内执行填报 导入 类型枚举
 */
@Getter
public enum ImportApType {
    /**
     * 常规陈列导入策略
     */
    NORMAL_DISPLAY_IMPORT("normalDisplayImportStrategy"),
    /**
     * 档期计划导入策略
     */
    PROMOTION_PLAN_IMPORT("promotionPlanImportStrategy"),
    /**
     * 零食陈列导入策略
     */
    SNACK_DISPLAY_IMPORT("snackDisplayImportStrategy"),
    /**
     * 三米两秒导入策略
     */
    THREE_METER_TWO_SECONDS_IMPORT("threeMeterSecondsImportStrategy"),
    /**
     * 六小金刚导入策略
     */
    SIX_KINGkONG_IMPORT("sixKingKongImportStrategy"),
    /**
     * 档期陈列导入策略
     */
    PROMOTION_DISPLAY_IMPORT("promotionDisplayImportStrategy");

    private final String importStrategy;
    ImportApType(String importStrategy) {
        this.importStrategy = importStrategy;
    }
}
