package com.sfa.operation.service.sales.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.operation.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.operation.domain.sales.dao.ISalesApDisplayDao;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDisplayDao;
import com.sfa.operation.domain.sales.dao.ISalesApSnacksDisplayDao;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.awt.dnd.Autoscroll;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
@Service
public class ApDisplayQueryServiceImpl implements IApDisplayQueryService {
    @Autowired
    private ISalesApDisplayDao salesApDisplayDao;
    @Autowired
    private ISalesApPromotionDisplayDao salesApPromotionDisplayDao;
    @Autowired
    private ISalesApSnacksDisplayDao salesapsnackdsDisplayDao;


    @Override
    public PageInfo page(SalesApRequest salesApRequest) {
        SalesApWq salesApWq = new SalesApWq();
        BeanUtils.copyProperties(salesApRequest,salesApWq);
        salesApWq.setSalesMonth(salesApRequest.getSalesMonth() != null ? DateUtil.parse(salesApRequest.getSalesMonth() + "-01", DatePattern.NORM_DATE_PATTERN) : null);
        return salesApDisplayDao.page(salesApWq);
    }

    @Override
    public PageInfo proPage(SalesApRequest salesApRequest) {
        SalesApWq salesApWq = new SalesApWq();
        BeanUtils.copyProperties(salesApRequest,salesApWq);
        salesApWq.setSalesMonth(salesApRequest.getSalesMonth() != null ? DateUtil.parse(salesApRequest.getSalesMonth() + "-01", DatePattern.NORM_DATE_PATTERN) : null);
        return salesApPromotionDisplayDao.page(salesApWq);
    }

    @Override
    public PageInfo snackPage(SalesApRequest salesApRequest) {
        SalesApWq salesApWq = new SalesApWq();
        BeanUtils.copyProperties(salesApRequest,salesApWq);
        salesApWq.setSalesMonth(salesApRequest.getSalesMonth() != null ? DateUtil.parse(salesApRequest.getSalesMonth() + "-01", DatePattern.NORM_DATE_PATTERN) : null);
        return salesapsnackdsDisplayDao.page(salesApWq);
    }
}
