package com.sfa.operation.strategy;

import com.sfa.operation.config.ExportColumnConfig;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.util.excel.ExcelUtils;

import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-08 16:17
 * @Description: 策略接口
 */
public interface IExportApExcelStrategy {
    /**
     * 获取导出列配置
     *
     * @return 导出列配置
     */
    List<ExportColumnConfig> getExportColumnConfig();

    /**
     * 查询数据
     *
     * @param salesApRequest 请求参数
     * @return 查询结果
     */
    List<?> queryData(SalesApRequest salesApRequest);

    /**
     * 获取导出sheet名称
     */
    String getExportSheetName();

    /**
     * 获取导出文件名前缀
     *
     * @return 导出文件名前缀
     */
    String getExportFileNamePrefix();

    /**
     * 生成excel
     *
     * @param salesApRequest 请求参数
     * @return excel字节数组
     */
    default byte[] generateExcel(SalesApRequest salesApRequest) throws Exception {
        return ExcelUtils.generateExcelBytes(
                this.getExportColumnConfig(),
                this.queryData(salesApRequest),
                this.getExportSheetName()
        );
    }
}
