package com.sfa.operation.domain.risk.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 风控-稽查门店表
 * @TableName risk_inspect_store
 */
@TableName(value ="risk_inspect_store")
@Data
public class RiskInspectStore implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long risId;

    /**
     * 店铺编码
     */
    private String storeCode;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺名称
     */
    private String rStoreName;

    /**
     * 店铺类型
     */
    private String storeType;

    /**
     * 店铺照片
     */
    private String storePictures;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商编码
     */
    private String dealerCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 坐标
     */
    private String coordinates;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}