package com.sfa.operation.domain.basedata.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_product
 */
@TableName(value ="base_product")
@Data
public class BaseProduct implements Serializable {
    /**
     * 唯一标识主键
     */
    @TableId(type = IdType.AUTO)
    private Integer bpId;

    /**
     * 料号
     */
    private String prdCode;

    /**
     * 品名
     */
    private String prdName;

    /**
     * 规格
     */
    private String prdBarCode;

    /**
     * 实际成本
     */
    private BigDecimal actualCost;

    /**
     * 标准成本
     */
    private BigDecimal standardCost;

    /**
     * 一级分类
     */
    private String firstCategory;

    /**
     * 二级分类
     */
    private String secondCategory;

    /**
     * 规格
     */
    private String spec;

    /**
     * 口味
     */
    private String flavor;

    /**
     * 产品分类编码
     */
    private String productClassificationCode;

    /**
     * 产品分类
     */
    private String productClassification;

    /**
     * 主分群码（重复字段，可根据实际需求调整）
     */
    private String mainGroupCode;

    /**
     * 主分群码名称
     */
    private String mainGroupName;

    /**
     * 料件类别（重复字段，可根据实际需求调整）
     */
    private String materialType;

    /**
     * 料件类别描述
     */
    private String materialTypeName;

    /**
     * 基础单位
     */
    private String basicUnit;

    /**
     * 生命周期状态
     */
    private String lifeCycleStatus;

    /**
     * 生命周期
     */
    private String lifeCycle;

    /**
     * 系列
     */
    private String series;

    /**
     * 批次
     */
    private Date batchNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 是否删除标志
     */
    private Integer delFlag;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 箱规
     */
    private Integer cartonSize;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}