package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.mapper.SalesApDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApDisplayDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
@DS("bi")
@Service
public class SalesApDisplayDaoImpl implements ISalesApDisplayDao {

    @Autowired
    private SalesApDisplayMapper salesapdisMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = buildWq(salesApWq);
        Page<SalesApDisplay> salesApDisplayPage = salesapdisMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo pageInfo = new PageInfo(salesApDisplayPage);
        return pageInfo;
    }

    @Override
    public void updateDetail(SalesApDisplayDto salesApDisplayDto) {
        SalesApDisplay salesApDisplay = salesapdisMapper.selectById(salesApDisplayDto.getSadId());
        if (!DateUtils.isSameYearMonth(salesApDisplay.getSalesMonth(),new Date())){
            throw new CheckedException(ECode.SALES_AP_UPDATE_ERROR);
        }
        SalesApDisplay updateDo = new SalesApDisplay();
        BeanUtils.copyProperties(salesApDisplayDto,updateDo);
        salesapdisMapper.updateById(updateDo);
    }

    @Override
    public Object queryStoreAPReport(SalesApWq build) {
        return salesapdisMapper.queryStoreAPReport(build);
    }

    @Override
    public Object queryDeptAPReport(SalesApWq build) {
        List<Map<String, Object>> mapZ = salesapdisMapper.queryDeptAPReportZQ(build);
        List<Map<String, Object>> mapD = salesapdisMapper.queryDeptAPReportDQ(build);
        List<Map<String, Object>> mapHZ = salesapdisMapper.queryDeptAPHZReportDQ(build);
        Map<String,Object> r = new HashMap<>();
        r.put("zq",mapZ);
        r.put("dq",mapD);
        r.put("hz",mapHZ);
        return r;

    }

    @Override
    public Object queryDistAPReport(SalesApWq build) {
        List<Map<String, Object>> mapDist = salesapdisMapper.queryDistAPReport(build);
        List<Map<String, Object>> mapDistHz = salesapdisMapper.queryDistAPHZReport(build);
        Map<String,Object> r = new HashMap<>();
        r.put("dist",mapDist);
        r.put("hz",mapDistHz);
        return r;
    }

    private LambdaQueryWrapper<SalesApDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(salesApWq.getDealerCode())) {
            qw.eq(SalesApDisplay::getDealerCode, salesApWq.getDealerCode());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApDisplay::getDealerCode, salesApWq.getDealerCodes());
        }
        if (StringUtils.isNotBlank(salesApWq.getCityManager())) {
            qw.eq(SalesApDisplay::getCityManager, salesApWq.getCityManager());
        }
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApDisplay::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApDisplay::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .like(SalesApDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApDisplay::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApDisplay::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplay::getActualMainShelfExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualEndCapExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualFloorStackExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getActualMultiDisplayExecuted, salesApWq.getRqStatus())
                            .or()
                            .eq(SalesApDisplay::getHangingStripExecuted, salesApWq.getRqStatus())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApDisplay::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
