package com.sfa.operation.controller.sales.query;

import com.sfa.common.core.context.UserRoles;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApPromotionQueryService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe :
 */
@RestController
@RequestMapping("/sales/ap_promotion/query")
public class ApPromotionQueryController {
    @Autowired
    private IApPromotionQueryService apPromotionQueryService;

    @RequiresPermissions("promotion:display_schedule:list")
    @GetMapping("/page")
    public PageInfo page(SalesApRequest salesApRequest){
        // 判断登录人权限
        LoginUser loginUser = SecurityUtils.getLoginUser();
        Set<String> roles = loginUser.getRoles();
        // 促销AP管理角色，可查看所有数据
        if (!roles.contains(UserRoles.PROMOTION_AP_MANAGER)) {
            // 查询当前人员部门、姓名
            String deptName = loginUser.getSysUser().getDept().getDeptName();
            String nickname = loginUser.getNickName();
            salesApRequest.setDeptName(deptName)
                    .setNickName(nickname);
        }
        return apPromotionQueryService.page(salesApRequest);
    }

}
